package jamezo97.clonecraft.network;

import org.apache.commons.lang3.ArrayUtils;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler12UpdateBlock extends Handler{
	
	@Value(id = 0)
	int entityId;
	
	@Value(id = 1)
	long[] values;
	
	@Value(id = 2)
	boolean setOrRemove;
	
	@Value(id = 3)
	boolean clearFirst;
	
	public Handler12UpdateBlock() {
		
	}
	
	public void print(long[] vals){
		if(values != null){
			for(int a = 0; a < vals.length; a++){
				System.out.print(vals[a] + ",");
			}
			System.out.println();
		}
		
	}
	
	public Handler12UpdateBlock(int entityId, boolean setOrRemove, boolean clearFirst, long... values) {
		this.entityId = entityId;
		this.values = values;
		
		this.setOrRemove = setOrRemove;
		this.clearFirst = clearFirst;
//		System.out.println("In: " + setOrRemove + "|" + clearFirst);
//		print(values);
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
//		System.out.println("Handle: " + setOrRemove + "|" + clearFirst);
//		print(values);
		if(side == Side.CLIENT){
			EntityClone clone = getCloneOnClient(entityId);
			if(clone != null){
				if(clearFirst){
					clone.options.clearSelectedBlocks();
				}
				if(setOrRemove){
					clone.options.addBlocksToBreak(values);
				}else{
					clone.options.removeBlocksToBreak(values);
				}
			}
		}else if(side == Side.SERVER){
			EntityClone clone = getCloneOnServer(entityId, player.worldObj.provider.dimensionId);
			if(clone != null && clone.canUseThisEntity(player.username)){
				if(clearFirst){
					clone.options.clearSelectedBlocks();
				}
				if(setOrRemove){
					clone.options.addBlocksToBreak(values);
				}else{
					clone.options.removeBlocksToBreak(values);
				}
				new Handler12UpdateBlock(entityId, true, true, clone.options.getAllBlocks()).sendToClients(clone.getWatchingOwners());
			}
		}
	}
	

}
